\ copy to $400 avoiding screen holes

include sixtyfive.fs

w6502 variant !
mbit xbit or short

include types.fs
include macro.fs
include 8bit.fs
include dos33.fs
include prodos8.fs

code-segment bank new-segment constant mainseg
code-segment bank new-segment constant auxseg

( direct page )

$fc constant tohere
$fe constant fromhere \ set by caller

mainseg switch-segment
$0300 torg


label start
  $3 tallot

label row
  ( copy $78 bytes )
  $00 # ldy,
  begin,
    fromhere (d),y lda,
    tohere (d),y sta,
    iny,
    $78 # cpy,
  zero until,

  ( advance pointers $80 bytes )

  fromhere @d lda,
  $80 # eor,
  fromhere @d sta,
  sign ~if,
    fromhere $1 + @d inc,
  then,

  tohere @d lda,
  $80 # eor,
  tohere @d sta,
  sign ~if,
    tohere $1 + @d inc,
  then,

  rts,


there start torg dup @a jmp, torg
  ( display 40 column text page 1 )
  $15 # lda,
  cout @a jsr,

  80coloff @a sta,
  80storeoff @a sta,
  page2off @a sta,
  texton @a sta,

  ( initialize to pointer )
  $0400 # tohere @d move2

  ( copy bytes )
  row @a jsr,
  row @a jsr,
  row @a jsr,
  row @a jsr,
  row @a jsr,
  row @a jsr,
  row @a jsr,
  row @a jmp,

there start - constant length

code-segment bank new-segment constant mainseg.out
mainseg.out switch-segment
start length mainseg copy-range

s" VIEW40" w/o bin create-file throw
dup mainseg.out write-segment
close-file throw

length cr hex.

cr .s
cr bye

